/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.baseclasses;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import minecrafttransportsimulator.baseclasses.BoundingBox;
import minecrafttransportsimulator.baseclasses.BoundingBoxHitResult;
import minecrafttransportsimulator.baseclasses.EntityInteractResult;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.entities.components.AEntityA_Base;
import minecrafttransportsimulator.entities.components.AEntityB_Existing;
import minecrafttransportsimulator.entities.components.AEntityC_Renderable;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.entities.components.AEntityG_Towable;
import minecrafttransportsimulator.entities.instances.APart;
import minecrafttransportsimulator.entities.instances.EntityBullet;
import minecrafttransportsimulator.entities.instances.EntityPlacedPart;
import minecrafttransportsimulator.entities.instances.EntityVehicleF_Physics;
import minecrafttransportsimulator.entities.instances.PartGun;
import minecrafttransportsimulator.items.instances.ItemVehicle;
import minecrafttransportsimulator.jsondefs.JSONCollisionGroup;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.InterfaceManager;

public abstract class EntityManager {
    public final ConcurrentLinkedQueue<AEntityA_Base> allEntities = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<AEntityA_Base> allNormalTickableEntities = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<AEntityA_Base> allPlayerTickableEntities = new ConcurrentLinkedQueue();
    public final ConcurrentLinkedQueue<AEntityC_Renderable> renderableEntities = new ConcurrentLinkedQueue();
    private final ConcurrentHashMap<Class<? extends AEntityA_Base>, ConcurrentLinkedQueue<? extends AEntityA_Base>> entitiesByClass = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, AEntityA_Base> trackedEntityMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, PartGun> gunMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<UUID, Map<Integer, EntityBullet>> bulletMap = new ConcurrentHashMap();
    private static final byte hotloadCountdownPreset = 20;
    private static byte hotloadCountdown;
    private static byte hotloadStep;
    private static HotloadFunction hotloadFunction;
    private static final Set<EntityManager> managersToHotload;
    private final Map<IWrapperNBT, ItemVehicle> hotloadedVehicles = new HashMap<IWrapperNBT, ItemVehicle>();
    private final Set<IWrapperNBT> hotloadedPlacedParts = new HashSet<IWrapperNBT>();
    private final Map<UUID, UUID> hotloadedRiderIDs = new HashMap<UUID, UUID>();
    private static final List<EntityManager> managers;

    public EntityManager() {
        managers.add(this);
    }

    public abstract AWrapperWorld getWorld();

    public <EntityType extends AEntityA_Base> void addEntity(EntityType entity) {
        ConcurrentLinkedQueue<AEntityA_Base> classList;
        this.allEntities.add(entity);
        if (entity.getUpdateTime() == AEntityA_Base.EntityAutoUpdateTime.NORMAL) {
            this.allNormalTickableEntities.add(entity);
        } else if (entity.getUpdateTime() == AEntityA_Base.EntityAutoUpdateTime.AFTER_PLAYER) {
            this.allPlayerTickableEntities.add(entity);
        }
        if (entity instanceof AEntityC_Renderable) {
            this.renderableEntities.add((AEntityC_Renderable)entity);
        }
        if (entity instanceof PartGun) {
            this.gunMap.put(entity.uniqueUUID, (PartGun)entity);
            this.bulletMap.put(entity.uniqueUUID, new HashMap());
        }
        if (entity instanceof EntityBullet) {
            EntityBullet bullet = (EntityBullet)entity;
            this.bulletMap.get(bullet.gun.uniqueUUID).put(bullet.bulletNumber, bullet);
        }
        if ((classList = this.entitiesByClass.get(entity.getClass())) == null) {
            classList = new ConcurrentLinkedQueue();
            this.entitiesByClass.put(entity.getClass(), classList);
        }
        classList.add(entity);
        if (entity.shouldSync()) {
            this.trackedEntityMap.put(entity.uniqueUUID, entity);
        }
    }

    public <EntityType extends AEntityA_Base> EntityType getEntity(UUID uniqueUUID) {
        return (EntityType)this.trackedEntityMap.get(uniqueUUID);
    }

    public PartGun getBulletGun(UUID gunID) {
        return this.gunMap.get(gunID);
    }

    public EntityBullet getBullet(UUID gunID, int bulletNumber) {
        return this.bulletMap.get(gunID).get(bulletNumber);
    }

    public <EntityType extends AEntityA_Base> ConcurrentLinkedQueue<EntityType> getEntitiesOfType(Class<EntityType> entityClass) {
        ConcurrentLinkedQueue<AEntityA_Base> classListing = this.entitiesByClass.get(entityClass);
        if (classListing == null) {
            classListing = new ConcurrentLinkedQueue();
            this.entitiesByClass.put(entityClass, classListing);
        }
        return classListing;
    }

    public <EntityType extends AEntityA_Base> List<EntityType> getEntitiesExtendingType(Class<EntityType> entityClass) {
        ArrayList list = new ArrayList();
        this.allEntities.forEach(entity -> {
            if (entityClass.isAssignableFrom(entity.getClass())) {
                list.add(entity);
            }
        });
        return list;
    }

    public void tickAll(boolean beforePlayer) {
        AWrapperWorld world;
        block26: {
            block25: {
                world = this.getWorld();
                if (world.isClient()) {
                    if (beforePlayer) {
                        world.beginProfiling("MTS_ClientEntityUpdatesPre", true);
                    } else {
                        world.beginProfiling("MTS_ClientEntityUpdatesPost", true);
                    }
                } else if (beforePlayer) {
                    world.beginProfiling("MTS_ServerEntityUpdatesPre", true);
                } else {
                    world.beginProfiling("MTS_ServerEntityUpdatesPost", true);
                }
                if (!beforePlayer) break block25;
                for (AEntityA_Base entity : this.allNormalTickableEntities) {
                    if (!(entity instanceof AEntityD_Definable)) continue;
                    ((AEntityD_Definable)entity).setVariableDefaults();
                }
                for (AEntityA_Base entity : this.allNormalTickableEntities) {
                    if (entity instanceof AEntityG_Towable && ((AEntityG_Towable)entity).blockMainUpdateCall()) continue;
                    EntityManager.doTick(entity);
                }
                if (hotloadStep <= 0) break block26;
                switch (hotloadStep) {
                    case 1: {
                        if (world.isClient()) {
                            if (hotloadCountdown != 0) break;
                            hotloadCountdown = (byte)20;
                            break;
                        }
                        if (!managersToHotload.contains(this)) break;
                        for (AEntityA_Base entity : this.allNormalTickableEntities) {
                            if (!(entity instanceof EntityVehicleF_Physics) && !(entity instanceof EntityPlacedPart)) continue;
                            AEntityD_Definable definable = (AEntityD_Definable)entity;
                            if (entity instanceof AEntityF_Multipart) {
                                ((AEntityF_Multipart)entity).allParts.forEach(part -> {
                                    if (part.rider != null) {
                                        this.hotloadedRiderIDs.put(part.uniqueUUID, part.rider.getID());
                                        part.removeRider();
                                    }
                                });
                            }
                            if (entity instanceof EntityVehicleF_Physics) {
                                this.hotloadedVehicles.put(definable.save(InterfaceManager.coreInterface.getNewNBTWrapper()), (ItemVehicle)definable.cachedItem);
                            } else if (entity instanceof EntityPlacedPart) {
                                this.hotloadedPlacedParts.add(definable.save(InterfaceManager.coreInterface.getNewNBTWrapper()));
                            }
                            definable.remove();
                        }
                        managersToHotload.remove(this);
                        break;
                    }
                    case 2: {
                        if (!world.isClient()) break;
                        hotloadFunction.apply();
                        hotloadCountdown = 1;
                        break;
                    }
                    case 3: {
                        if (world.isClient()) {
                            if (hotloadCountdown != 0) break;
                            hotloadCountdown = (byte)20;
                            break;
                        }
                        this.hotloadedVehicles.forEach((data, item) -> {
                            EntityVehicleF_Physics vehicle = new EntityVehicleF_Physics(this.getWorld(), null, (ItemVehicle)item, (IWrapperNBT)data);
                            vehicle.addPartsPostAddition(null, (IWrapperNBT)data);
                            vehicle.world.spawnEntity(vehicle);
                        });
                        this.hotloadedVehicles.clear();
                        this.hotloadedPlacedParts.forEach(data -> {
                            EntityPlacedPart placedPart = new EntityPlacedPart(this.getWorld(), null, (IWrapperNBT)data);
                            placedPart.addPartsPostAddition(null, (IWrapperNBT)data);
                            placedPart.world.spawnEntity(placedPart);
                        });
                        this.hotloadedPlacedParts.clear();
                        break;
                    }
                    case 4: {
                        if (world.isClient()) {
                            if (hotloadCountdown != 0) break;
                            hotloadCountdown = (byte)20;
                            break;
                        }
                        this.hotloadedRiderIDs.forEach((seatID, riderID) -> this.getWorld().getExternalEntity((UUID)riderID).setRiding((AEntityB_Existing)this.getWorld().getEntity((UUID)seatID)));
                        this.hotloadedRiderIDs.clear();
                        break;
                    }
                    case 5: {
                        hotloadStep = 0;
                    }
                }
                if (hotloadStep == 0 || !world.isClient() || (hotloadCountdown = (byte)(hotloadCountdown - 1)) != 0) break block26;
                hotloadStep = (byte)(hotloadStep + 1);
                break block26;
            }
            for (AEntityA_Base entity : this.allPlayerTickableEntities) {
                if (!(entity instanceof AEntityD_Definable)) continue;
                ((AEntityD_Definable)entity).setVariableDefaults();
            }
            for (AEntityA_Base entity : this.allPlayerTickableEntities) {
                if (entity instanceof AEntityG_Towable && ((AEntityG_Towable)entity).blockMainUpdateCall()) continue;
                EntityManager.doTick(entity);
            }
        }
        world.endProfiling();
    }

    public static void doTick(AEntityA_Base entity) {
        entity.world.beginProfiling("MTSEntity_" + entity.uniqueUUID, true);
        if (entity instanceof AEntityD_Definable) {
            AEntityD_Definable definable = (AEntityD_Definable)entity;
            entity.world.beginProfiling("VariableModifiers", true);
            definable.updateVariableModifiers();
            entity.world.beginProfiling("MainUpdate", false);
            entity.update();
            entity.world.beginProfiling("PostUpdate", false);
            definable.doPostUpdateLogic();
            entity.world.endProfiling();
        } else {
            entity.update();
        }
        entity.world.endProfiling();
    }

    public EntityInteractResult getMultipartEntityIntersect(Point3D startPoint, Point3D endPoint) {
        EntityInteractResult closestResult = null;
        BoundingBox vectorBounds = new BoundingBox(startPoint, endPoint);
        ArrayList<AEntityF_Multipart> multiparts = new ArrayList<AEntityF_Multipart>();
        multiparts.addAll(this.getEntitiesOfType(EntityVehicleF_Physics.class));
        multiparts.addAll(this.getEntitiesOfType(EntityPlacedPart.class));
        for (AEntityF_Multipart multipart : multiparts) {
            if (!multipart.encompassingBox.intersects(vectorBounds) || !multipart.canBeClicked()) continue;
            for (BoundingBox box : multipart.allCollisionBoxes) {
                BoundingBoxHitResult intersectionPoint;
                if (!box.collisionTypes.contains((Object)JSONCollisionGroup.CollisionType.CLICK) || !box.intersects(vectorBounds) || (intersectionPoint = box.getIntersection(startPoint, endPoint)) == null || closestResult != null && !startPoint.isFirstCloserThanSecond(intersectionPoint.position, closestResult.position)) continue;
                APart part = multipart.getPartWithBox(box);
                if (part != null) {
                    if (!part.canBeClicked()) continue;
                    closestResult = new EntityInteractResult(part, box, intersectionPoint.position);
                    continue;
                }
                closestResult = new EntityInteractResult(multipart, box, intersectionPoint.position);
            }
        }
        return closestResult;
    }

    public void removeEntity(AEntityA_Base entity) {
        this.allEntities.remove(entity);
        this.allNormalTickableEntities.remove(entity);
        this.allPlayerTickableEntities.remove(entity);
        if (entity instanceof AEntityC_Renderable) {
            this.renderableEntities.remove(entity);
        }
        this.entitiesByClass.get(entity.getClass()).remove(entity);
        if (entity.shouldSync()) {
            this.trackedEntityMap.remove(entity.uniqueUUID);
        }
        if (entity instanceof EntityBullet) {
            EntityBullet bullet = (EntityBullet)entity;
            this.bulletMap.get(bullet.gun.uniqueUUID).remove(bullet.bulletNumber);
        }
    }

    public void adjustHeightForRain(Point3D position) {
        for (EntityVehicleF_Physics vehicle : this.getEntitiesOfType(EntityVehicleF_Physics.class)) {
            if (!vehicle.encompassingBox.isPointInsideAndBelow(position)) continue;
            for (BoundingBox box : vehicle.allCollisionBoxes) {
                if (!box.collisionTypes.contains((Object)JSONCollisionGroup.CollisionType.ENTITY)) continue;
                position.x -= 0.5;
                position.z -= 0.5;
                if (box.isPointInsideAndBelow(position)) {
                    position.y = box.globalCenter.y + box.heightRadius;
                    position.x += 0.5;
                    position.z += 0.5;
                    continue;
                }
                position.x += 1.0;
                if (box.isPointInsideAndBelow(position)) {
                    position.y = box.globalCenter.y + box.heightRadius;
                    position.x -= 0.5;
                    position.z += 0.5;
                    continue;
                }
                position.z += 1.0;
                if (box.isPointInsideAndBelow(position)) {
                    position.y = box.globalCenter.y + box.heightRadius;
                    position.x -= 0.5;
                    position.z -= 0.5;
                    continue;
                }
                position.x -= 1.0;
                if (box.isPointInsideAndBelow(position)) {
                    position.y = box.globalCenter.y + box.heightRadius;
                }
                position.x += 0.5;
                position.z -= 0.5;
            }
        }
    }

    public static void doImports(HotloadFunction hotloadFunction) {
        for (EntityManager manager : managers) {
            if (manager.getWorld().isClient()) continue;
            managersToHotload.add(manager);
        }
        EntityManager.hotloadFunction = hotloadFunction;
        hotloadStep = 1;
    }

    static {
        managersToHotload = new HashSet<EntityManager>();
        managers = new ArrayList<EntityManager>();
    }

    @FunctionalInterface
    public static interface HotloadFunction {
        public void apply();
    }
}

